{ *********************************************************************** }
{                                                                         }
{ Delphi Visual Component Library                                         }
{                                                                         }
{ Copyright (c) 1995-2004 Borland Software Corporation                    }
{                                                                         }
{ *********************************************************************** }

{*******************************************************}
{       ADO Interface Unit                              }
{*******************************************************}

unit Borland.Vcl.ADOInt platform;

// ********************************************************************* //
// Type Lib: C:\PROGRAM FILES\COMMON FILES\SYSTEM\ADO\MSADO15.DLL        //
// IID\LCID: {00000200-0000-0010-8000-00AA006D2EA4}\0                    //
// PASTLWTR : 1.1                                        //
// HelpString: Microsoft ActiveX Data Objects 2.1 Library                //
// Version:    2.1                                                       //
// ********************************************************************* //

interface

uses Windows, ActiveX, Variants, System.Runtime.InteropServices;

{ Utility declarations for 'native' variants }

type
  TOleVarData = packed record
    case Integer of
      0: (VT: Int16;
          _Reserved1: Int16;
          _Reserved2: Int32;
          case Integer of
            VT_UI1:  (bVal: Byte);
            VT_I2:   (iVal: Smallint);
            VT_I4:   (lVal: Longint);
            VT_R4:   (fltVal: Single);
            VT_R8:   (dblVal: Int64);     { Double }
            VT_BOOL: (vBool: WordBool);
            VT_CY:   (cyVal: TOACurrency);
            VT_DATE: (vDate: Int64);      { Double, TOleDate }
            VT_BSTR: (bStrVal: IntPtr);   { PWideChar, WideString }
            VT_I1:   (cVal: ShortInt);
            VT_UI2:  (uiVal: Word);
            VT_UI4:  (ulVal: LongWord);
            VT_INT:  (intVal: Integer);
            VT_I8:   (int64Val: Int64);
            VT_ARRAY:(pArray: PSafeArray)
         );
      1: (Reserved1: Int64; Reserved2: Int64);
  end;

const
  NullVariantData: TOleVarData = (Reserved1:1; Reserved2:0);
  EmptyParamData: TOleVarData  = (Reserved1:10; Reserved2:$80020004);

// ********************************************************************* //
// GUIDS declared in the TypeLibrary. Following prefixes are used:       //
//   Type Libraries     : LIBID_xxxx                                     //
//   CoClasses          : CLASS_xxxx                                     //
//   DISPInterfaces     : DIID_xxxx                                      //
//   Non-DISP interfaces: IID_xxxx                                       //
// ********************************************************************* //
const
  LIBID_ADODB{: TGUID} = '{00000201-0000-0010-8000-00AA006D2EA4}';
  CLASS_Connection{: TGUID} = '{00000514-0000-0010-8000-00AA006D2EA4}';
  CLASS_Command{: TGUID} = '{00000507-0000-0010-8000-00AA006D2EA4}';
  CLASS_Recordset{: TGUID} = '{00000535-0000-0010-8000-00AA006D2EA4}';
  CLASS_Parameter{: TGUID} = '{0000050B-0000-0010-8000-00AA006D2EA4}';
  CLASS_DataSpace{: TGUID} = '{BD96C556-65A3-11D0-983A-00C04FC29E36}';
  CLASS_DataFactory{: TGUID} = '{9381D8F5-0288-11D0-9501-00AA00B911A5}';
  IID__Collection{: TGUID} = '{00000512-0000-0010-8000-00AA006D2EA4}';
  IID__DynaCollection{: TGUID} = '{00000513-0000-0010-8000-00AA006D2EA4}';
  IID__ADO{: TGUID} = '{00000534-0000-0010-8000-00AA006D2EA4}';
  IID_Properties{: TGUID} = '{00000504-0000-0010-8000-00AA006D2EA4}';
  IID_Property_{: TGUID} = '{00000503-0000-0010-8000-00AA006D2EA4}';
  IID_Error{: TGUID} = '{00000500-0000-0010-8000-00AA006D2EA4}';
  IID_Errors{: TGUID} = '{00000501-0000-0010-8000-00AA006D2EA4}';
  IID_Command15{: TGUID} = '{00000508-0000-0010-8000-00AA006D2EA4}';
  IID_Connection15{: TGUID} = '{00000515-0000-0010-8000-00AA006D2EA4}';
  IID__Connection{: TGUID} = '{00000550-0000-0010-8000-00AA006D2EA4}';
  IID_Recordset15{: TGUID} = '{0000050E-0000-0010-8000-00AA006D2EA4}';
  IID_Recordset20{: TGUID} = '{0000054F-0000-0010-8000-00AA006D2EA4}';
  IID__Recordset{: TGUID} = '{00000555-0000-0010-8000-00AA006D2EA4}';
  IID_Fields15{: TGUID} = '{00000506-0000-0010-8000-00AA006D2EA4}';
  IID_Fields{: TGUID} = '{0000054D-0000-0010-8000-00AA006D2EA4}';
  IID_Field{: TGUID} = '{0000054C-0000-0010-8000-00AA006D2EA4}';
  IID__Parameter{: TGUID} = '{0000050C-0000-0010-8000-00AA006D2EA4}';
  IID_Parameters{: TGUID} = '{0000050D-0000-0010-8000-00AA006D2EA4}';
  IID__Command{: TGUID} = '{0000054E-0000-0010-8000-00AA006D2EA4}';
  IID_ConnectionEventsVt{: TGUID} = '{00000402-0000-0010-8000-00AA006D2EA4}';
  DIID_ConnectionEvents{: TGUID} = '{00000400-0000-0010-8000-00AA006D2EA4}';
  IID_RecordsetEventsVt{: TGUID} = '{00000403-0000-0010-8000-00AA006D2EA4}';
  DIID_RecordsetEvents{: TGUID} = '{00000266-0000-0010-8000-00AA006D2EA4}';
  IID_ADOConnectionConstruction15{: TGUID} = '{00000516-0000-0010-8000-00AA006D2EA4}';
  IID_ADOConnectionConstruction{: TGUID} = '{00000551-0000-0010-8000-00AA006D2EA4}';
  IID_ADOCommandConstruction{: TGUID} = '{00000517-0000-0010-8000-00AA006D2EA4}';
  IID_ADORecordsetConstruction{: TGUID} = '{00000283-0000-0010-8000-00AA006D2EA4}';
  IID_Field15{: TGUID} = '{00000505-0000-0010-8000-00AA006D2EA4}';
  IID_IDataspace{: TGUID} = '{BD96C556-65A3-11D0-983A-00C04FC29E34}';

// *********************************************************************//
// Misc. Constants (not from Type Library)                              //
// *********************************************************************//

// ConnectionString Tags
const
  CT_USERID = 'USER ID=';     { Do not localize }
  CT_PROVIDER = 'PROVIDER=';  { Do not localize }
  CT_FILENAME = 'FILE NAME='; { Do not localize }

// *********************************************************************//
// Declaration of Enumerations defined in Type Library                  //
// *********************************************************************//

// CursorTypeEnum constants
type
  CursorTypeEnum = TOleEnum;
const
  adOpenUnspecified = $FFFFFFFF;
  adOpenForwardOnly = $00000000;
  adOpenKeyset = $00000001;
  adOpenDynamic = $00000002;
  adOpenStatic = $00000003;

// CursorOptionEnum constants
type
  CursorOptionEnum = TOleEnum;
const
  adHoldRecords = $00000100;
  adMovePrevious = $00000200;
  adAddNew = $01000400;
  adDelete = $01000800;
  adUpdate = $01008000;
  adBookmark = $00002000;
  adApproxPosition = $00004000;
  adUpdateBatch = $00010000;
  adResync = $00020000;
  adNotify = $00040000;
  adFind = $00080000;
  adSeek = $00400000;
  adIndex = $00800000;

// LockTypeEnum constants
type
  LockTypeEnum = TOleEnum;
const
  adLockUnspecified = $FFFFFFFF;
  adLockReadOnly = $00000001;
  adLockPessimistic = $00000002;
  adLockOptimistic = $00000003;
  adLockBatchOptimistic = $00000004;

// ExecuteOptionEnum constants
type
  ExecuteOptionEnum = TOleEnum;
const
  adOptionUnspecified = $FFFFFFFF;
  adAsyncExecute = $00000010;
  adAsyncFetch = $00000020;
  adAsyncFetchNonBlocking = $00000040;
  adExecuteNoRecords = $00000080;

// ConnectOptionEnum constants
type
  ConnectOptionEnum = TOleEnum;
const
  adConnectUnspecified = $FFFFFFFF;
  adAsyncConnect = $00000010;

// ObjectStateEnum constants
type
  ObjectStateEnum = TOleEnum;
const
  adStateClosed = $00000000;
  adStateOpen = $00000001;
  adStateConnecting = $00000002;
  adStateExecuting = $00000004;
  adStateFetching = $00000008;

// CursorLocationEnum constants
type
  CursorLocationEnum = TOleEnum;
const
  adUseNone = $00000001;
  adUseServer = $00000002;
  adUseClient = $00000003;
  adUseClientBatch = $00000003;

// DataTypeEnum constants
type
  DataTypeEnum = TOleEnum;
const
  adEmpty = $00000000;
  adTinyInt = $00000010;
  adSmallInt = $00000002;
  adInteger = $00000003;
  adBigInt = $00000014;
  adUnsignedTinyInt = $00000011;
  adUnsignedSmallInt = $00000012;
  adUnsignedInt = $00000013;
  adUnsignedBigInt = $00000015;
  adSingle = $00000004;
  adDouble = $00000005;
  adCurrency = $00000006;
  adDecimal = $0000000E;
  adNumeric = $00000083;
  adBoolean = $0000000B;
  adError = $0000000A;
  adUserDefined = $00000084;
  adVariant = $0000000C;
  adIDispatch = $00000009;
  adIUnknown = $0000000D;
  adGUID = $00000048;
  adDate = $00000007;
  adDBDate = $00000085;
  adDBTime = $00000086;
  adDBTimeStamp = $00000087;
  adBSTR = $00000008;
  adChar = $00000081;
  adVarChar = $000000C8;
  adLongVarChar = $000000C9;
  adWChar = $00000082;
  adVarWChar = $000000CA;
  adLongVarWChar = $000000CB;
  adBinary = $00000080;
  adVarBinary = $000000CC;
  adLongVarBinary = $000000CD;
  adChapter = $00000088;
  adFileTime = $00000040;
  adDBFileTime = $00000089;
  adPropVariant = $0000008A;
  adVarNumeric = $0000008B;

// FieldAttributeEnum constants
type
  FieldAttributeEnum = TOleEnum;
const
  adFldUnspecified = $FFFFFFFF;
  adFldMayDefer = $00000002;
  adFldUpdatable = $00000004;
  adFldUnknownUpdatable = $00000008;
  adFldFixed = $00000010;
  adFldIsNullable = $00000020;
  adFldMayBeNull = $00000040;
  adFldLong = $00000080;
  adFldRowID = $00000100;
  adFldRowVersion = $00000200;
  adFldCacheDeferred = $00001000;
  adFldNegativeScale = $00004000;
  adFldKeyColumn = $00008000;

// EditModeEnum constants
type
  EditModeEnum = TOleEnum;
const
  adEditNone = $00000000;
  adEditInProgress = $00000001;
  adEditAdd = $00000002;
  adEditDelete = $00000004;

// RecordStatusEnum constants
type
  RecordStatusEnum = TOleEnum;
const
  adRecOK = $00000000;
  adRecNew = $00000001;
  adRecModified = $00000002;
  adRecDeleted = $00000004;
  adRecUnmodified = $00000008;
  adRecInvalid = $00000010;
  adRecMultipleChanges = $00000040;
  adRecPendingChanges = $00000080;
  adRecCanceled = $00000100;
  adRecCantRelease = $00000400;
  adRecConcurrencyViolation = $00000800;
  adRecIntegrityViolation = $00001000;
  adRecMaxChangesExceeded = $00002000;
  adRecObjectOpen = $00004000;
  adRecOutOfMemory = $00008000;
  adRecPermissionDenied = $00010000;
  adRecSchemaViolation = $00020000;
  adRecDBDeleted = $00040000;

// GetRowsOptionEnum constants
type
  GetRowsOptionEnum = TOleEnum;
const
  adGetRowsRest = $FFFFFFFF;

// PositionEnum constants
type
  PositionEnum = TOleEnum;
const
  adPosUnknown = $FFFFFFFF;
  adPosBOF = $FFFFFFFE;
  adPosEOF = $FFFFFFFD;

// BookmarkEnum constants
type
  BookmarkEnum = TOleEnum;
const
  adBookmarkCurrent = $00000000;
  adBookmarkFirst = $00000001;
  adBookmarkLast = $00000002;

// MarshalOptionsEnum constants
type
  MarshalOptionsEnum = TOleEnum;
const
  adMarshalAll = $00000000;
  adMarshalModifiedOnly = $00000001;

// AffectEnum constants
type
  AffectEnum = TOleEnum;
const
  adAffectCurrent = $00000001;
  adAffectGroup = $00000002;
  adAffectAll = $00000003;
  adAffectAllChapters = $00000004;

// ResyncEnum constants
type
  ResyncEnum = TOleEnum;
const
  adResyncUnderlyingValues = $00000001;
  adResyncAllValues = $00000002;

// CompareEnum constants
type
  CompareEnum = TOleEnum;
const
  adCompareLessThan = $00000000;
  adCompareEqual = $00000001;
  adCompareGreaterThan = $00000002;
  adCompareNotEqual = $00000003;
  adCompareNotComparable = $00000004;

// FilterGroupEnum constants
type
  FilterGroupEnum = TOleEnum;
const
  adFilterNone = $00000000;
  adFilterPendingRecords = $00000001;
  adFilterAffectedRecords = $00000002;
  adFilterFetchedRecords = $00000003;
  adFilterPredicate = $00000004;
  adFilterConflictingRecords = $00000005;

// SearchDirectionEnum constants
type
  SearchDirectionEnum = TOleEnum;
const
  adSearchForward = $00000001;
  adSearchBackward = $FFFFFFFF;

// PersistFormatEnum constants
type
  PersistFormatEnum = TOleEnum;
const
  adPersistADTG = $00000000;
  adPersistXML = $00000001;

// StringFormatEnum constants
type
  StringFormatEnum = TOleEnum;
const
  adClipString = $00000002;

// ConnectPromptEnum constants
type
  ConnectPromptEnum = TOleEnum;
const
  adPromptAlways = $00000001;
  adPromptComplete = $00000002;
  adPromptCompleteRequired = $00000003;
  adPromptNever = $00000004;

// ConnectModeEnum constants
type
  ConnectModeEnum = TOleEnum;
const
  adModeUnknown = $00000000;
  adModeRead = $00000001;
  adModeWrite = $00000002;
  adModeReadWrite = $00000003;
  adModeShareDenyRead = $00000004;
  adModeShareDenyWrite = $00000008;
  adModeShareExclusive = $0000000C;
  adModeShareDenyNone = $00000010;

// IsolationLevelEnum constants
type
  IsolationLevelEnum = TOleEnum;
const
  adXactUnspecified = $FFFFFFFF;
  adXactChaos = $00000010;
  adXactReadUncommitted = $00000100;
  adXactBrowse = $00000100;
  adXactCursorStability = $00001000;
  adXactReadCommitted = $00001000;
  adXactRepeatableRead = $00010000;
  adXactSerializable = $00100000;
  adXactIsolated = $00100000;

// XactAttributeEnum constants
type
  XactAttributeEnum = TOleEnum;
const
  adXactCommitRetaining = $00020000;
  adXactAbortRetaining = $00040000;
  adXactAsyncPhaseOne = $00080000;
  adXactSyncPhaseOne = $00100000;

// PropertyAttributesEnum constants
type
  PropertyAttributesEnum = TOleEnum;
const
  adPropNotSupported = $00000000;
  adPropRequired = $00000001;
  adPropOptional = $00000002;
  adPropRead = $00000200;
  adPropWrite = $00000400;

// ErrorValueEnum constants
type
  ErrorValueEnum = TOleEnum;
const
  adErrInvalidArgument = $00000BB9;
  adErrNoCurrentRecord = $00000BCD;
  adErrIllegalOperation = $00000C93;
  adErrInTransaction = $00000CAE;
  adErrFeatureNotAvailable = $00000CB3;
  adErrItemNotFound = $00000CC1;
  adErrObjectInCollection = $00000D27;
  adErrObjectNotSet = $00000D5C;
  adErrDataConversion = $00000D5D;
  adErrObjectClosed = $00000E78;
  adErrObjectOpen = $00000E79;
  adErrProviderNotFound = $00000E7A;
  adErrBoundToCommand = $00000E7B;
  adErrInvalidParamInfo = $00000E7C;
  adErrInvalidConnection = $00000E7D;
  adErrNotReentrant = $00000E7E;
  adErrStillExecuting = $00000E7F;
  adErrOperationCancelled = $00000E80;
  adErrStillConnecting = $00000E81;
  adErrNotExecuting = $00000E83;
  adErrUnsafeOperation = $00000E84;

// ParameterAttributesEnum constants
type
  ParameterAttributesEnum = TOleEnum;
const
  adParamSigned = $00000010;
  adParamNullable = $00000040;
  adParamLong = $00000080;

// ParameterDirectionEnum constants
type
  ParameterDirectionEnum = TOleEnum;
const
  adParamUnknown = $00000000;
  adParamInput = $00000001;
  adParamOutput = $00000002;
  adParamInputOutput = $00000003;
  adParamReturnValue = $00000004;

// CommandTypeEnum constants
type
  CommandTypeEnum = TOleEnum;
const
  adCmdUnspecified = $FFFFFFFF;
  adCmdUnknown = $00000008;
  adCmdText = $00000001;
  adCmdTable = $00000002;
  adCmdStoredProc = $00000004;
  adCmdFile = $00000100;
  adCmdTableDirect = $00000200;

// EventStatusEnum constants
type
  EventStatusEnum = TOleEnum;
const
  adStatusOK = $00000001;
  adStatusErrorsOccurred = $00000002;
  adStatusCantDeny = $00000003;
  adStatusCancel = $00000004;
  adStatusUnwantedEvent = $00000005;

// EventReasonEnum constants
type
  EventReasonEnum = TOleEnum;
const
  adRsnAddNew = $00000001;
  adRsnDelete = $00000002;
  adRsnUpdate = $00000003;
  adRsnUndoUpdate = $00000004;
  adRsnUndoAddNew = $00000005;
  adRsnUndoDelete = $00000006;
  adRsnRequery = $00000007;
  adRsnResynch = $00000008;
  adRsnClose = $00000009;
  adRsnMove = $0000000A;
  adRsnFirstChange = $0000000B;
  adRsnMoveFirst = $0000000C;
  adRsnMoveNext = $0000000D;
  adRsnMovePrevious = $0000000E;
  adRsnMoveLast = $0000000F;

// SchemaEnum constants
type
  SchemaEnum = TOleEnum;
const
  adSchemaProviderSpecific = $FFFFFFFF;
  adSchemaAsserts = $00000000;
  adSchemaCatalogs = $00000001;
  adSchemaCharacterSets = $00000002;
  adSchemaCollations = $00000003;
  adSchemaColumns = $00000004;
  adSchemaCheckConstraints = $00000005;
  adSchemaConstraintColumnUsage = $00000006;
  adSchemaConstraintTableUsage = $00000007;
  adSchemaKeyColumnUsage = $00000008;
  adSchemaReferentialConstraints = $00000009;
  adSchemaTableConstraints = $0000000A;
  adSchemaColumnsDomainUsage = $0000000B;
  adSchemaIndexes = $0000000C;
  adSchemaColumnPrivileges = $0000000D;
  adSchemaTablePrivileges = $0000000E;
  adSchemaUsagePrivileges = $0000000F;
  adSchemaProcedures = $00000010;
  adSchemaSchemata = $00000011;
  adSchemaSQLLanguages = $00000012;
  adSchemaStatistics = $00000013;
  adSchemaTables = $00000014;
  adSchemaTranslations = $00000015;
  adSchemaProviderTypes = $00000016;
  adSchemaViews = $00000017;
  adSchemaViewColumnUsage = $00000018;
  adSchemaViewTableUsage = $00000019;
  adSchemaProcedureParameters = $0000001A;
  adSchemaForeignKeys = $0000001B;
  adSchemaPrimaryKeys = $0000001C;
  adSchemaProcedureColumns = $0000001D;
  adSchemaDBInfoKeywords = $0000001E;
  adSchemaDBInfoLiterals = $0000001F;
  adSchemaCubes = $00000020;
  adSchemaDimensions = $00000021;
  adSchemaHierarchies = $00000022;
  adSchemaLevels = $00000023;
  adSchemaMeasures = $00000024;
  adSchemaProperties = $00000025;
  adSchemaMembers = $00000026;
  adSchemaTrustees = $00000027;

// SeekEnum constants
type
  SeekEnum = TOleEnum;
const
  adSeekFirstEQ = $00000001;
  adSeekLastEQ = $00000002;
  adSeekAfterEQ = $00000004;
  adSeekAfter = $00000008;
  adSeekBeforeEQ = $00000010;
  adSeekBefore = $00000020;

// ADCPROP_UPDATECRITERIA_ENUM constants
type
  ADCPROP_UPDATECRITERIA_ENUM = TOleEnum;
const
  adCriteriaKey = $00000000;
  adCriteriaAllCols = $00000001;
  adCriteriaUpdCols = $00000002;
  adCriteriaTimeStamp = $00000003;

// ADCPROP_ASYNCTHREADPRIORITY_ENUM constants
type
  ADCPROP_ASYNCTHREADPRIORITY_ENUM = TOleEnum;
const
  adPriorityLowest = $00000001;
  adPriorityBelowNormal = $00000002;
  adPriorityNormal = $00000003;
  adPriorityAboveNormal = $00000004;
  adPriorityHighest = $00000005;

// CEResyncEnum constants
type
  CEResyncEnum = TOleEnum;
const
  adResyncNone = $00000000;
  adResyncAutoIncrement = $00000001;
  adResyncConflicts = $00000002;
  adResyncUpdates = $00000004;
  adResyncInserts = $00000008;
  adResyncAll = $0000000F;

// ADCPROP_AUTORECALC_ENUM constants
type
  ADCPROP_AUTORECALC_ENUM = TOleEnum;
const
  adRecalcUpFront = $00000000;
  adRecalcAlways = $00000001;

type

// *********************************************************************//
// Forward declaration of interfaces defined in Type Library            //
// *********************************************************************//

  _Collection = interface;
//  _CollectionDisp = interface;

  _DynaCollection = interface;
//  _DynaCollectionDisp = interface;

  _ADO = interface;
//  _ADODisp = interface;

  Properties = interface;
//  PropertiesDisp = interface;

  Property_ = interface;
//  Property_Disp = interface;

  Error = interface;
//  ErrorDisp = interface;

  Errors = interface;
//  ErrorsDisp = interface;

  Command15 = interface;
//  Command15Disp = interface;
{
  Connection15 = interface;
  Connection15Disp = interface;
}
  _Connection = interface;
//  _ConnectionDisp = interface;

  Recordset15 = interface;
//  Recordset15Disp = interface;

  Recordset20 = interface;
//  Recordset20Disp = interface;

  _Recordset = interface;
//  _RecordsetDisp = interface;

  Fields15 = interface;
//  Fields15Disp = interface;

  Fields = interface;
//  FieldsDisp = interface;

  Field = interface;
//  FieldDisp = interface;

  _Parameter = interface;
//  _ParameterDisp = interface;

  Parameters = interface;
//  ParametersDisp = interface;

  _Command = interface;
//  _CommandDisp = interface;
{
  ConnectionEventsVt = interface;
  RecordsetEventsVt = interface;

  ConnectionEvents = interface;
  RecordsetEvents = interface;

  ADOConnectionConstruction15 = interface;
  ADOConnectionConstruction = interface;
}
  ADOCommandConstruction = interface;
  ADORecordsetConstruction = interface;
{
  Field15 = interface;
  Field15Disp = interface;
}
  IDataspace = interface;
//  IDataspaceDisp = interface;

// *********************************************************************//
// Declaration of CoClasses defined in Type Library                     //
// (NOTE: Here we map each CoClass to its Default Interface)            //
// *********************************************************************//

  Connection = _Connection;
  Command = _Command;
  Recordset = _Recordset;
  Parameter = _Parameter;
  DataSpace = IDataspace;


// *********************************************************************//
// Declaration of structures, unions and aliases.                       //
// *********************************************************************//

  SearchDirection = SearchDirectionEnum;

// *********************************************************************//
// Interface: _Collection
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000512-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000512-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  _Collection = interface { (IDispatch) }
    function get_Count: Integer;
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function _NewEnum: TObject; // IUnknown
    procedure Refresh;
    property Count: Integer read get_Count;
  end;

// *********************************************************************//
// DispIntf:  _CollectionDisp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000512-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  _CollectionDisp = dispinterface
    ['{00000512-0000-0010-8000-00AA006D2EA4}']
    property Count: Integer readonly dispid 1610743808;
    function _NewEnum: IUnknown; dispid -4;
    procedure Refresh; dispid 1610743810;
  end;
*)
// *********************************************************************//
// Interface: _DynaCollection
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000513-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//

  [ComImport,
  GuidAttribute('00000513-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  _DynaCollection = interface { (_Collection) }
    // _Collection
    function get_Count: Integer;
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function _NewEnum: TObject; // IUnknown
    procedure Refresh;
    property Count: Integer read get_Count;

    // _DynaCollection
    procedure Append([MarshalAs(UnmanagedType.IDispatch)] const Object_: TObject);
    procedure Delete(Index: OleVariant);
  end;

// *********************************************************************//
// DispIntf:  _DynaCollectionDisp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000513-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  _DynaCollectionDisp = interface
    ['{00000513-0000-0010-8000-00AA006D2EA4}']
    procedure Append(const Object_: IDispatch); dispid 1610809344;
    procedure Delete(Index: OleVariant); dispid 1610809345;
    property Count: Integer readonly dispid 1610743808;
    function _NewEnum: IUnknown; dispid -4;
    procedure Refresh; dispid 1610743810;
  end;
*)
// *********************************************************************//
// Interface: _ADO
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000534-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000534-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  _ADO = interface { (IDispatch) }
    function get_Properties: Properties;
    property Properties: Properties read get_Properties;
  end;

// *********************************************************************//
// DispIntf:  _ADODisp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000534-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  _ADODisp = interface
    ['{00000534-0000-0010-8000-00AA006D2EA4}']
    property Properties: Properties readonly dispid 500;
  end;
*)
// *********************************************************************//
// Interface: Properties
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000504-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000504-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  Properties = interface { (_Collection) }
    // _Collection
    function get_Count: Integer;
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function _NewEnum: TObject; // IUnknown
    procedure Refresh;
    property Count: Integer read get_Count;

    // Properties
    function get_Item(Index: OleVariant): Property_;
    property Item[Index: OleVariant]: Property_ read get_Item;
  end;

// *********************************************************************//
// DispIntf:  PropertiesDisp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000504-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  PropertiesDisp = interface
    ['{00000504-0000-0010-8000-00AA006D2EA4}']
    property Item[Index: OleVariant]: Property_ readonly dispid 0; default;
    property Count: Integer readonly dispid 1610743808;
    function _NewEnum: IUnknown; dispid -4;
    procedure Refresh; dispid 1610743810;
  end;
*)
// *********************************************************************//
// Interface: Property_
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000503-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000503-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  Property_ = interface { (IDispatch) }
    function get_Value: OleVariant;
    procedure set_Value(pval: OleVariant);
    function get_Name: WideString;
    function get_Type_: DataTypeEnum;
    function get_Attributes: Integer;
    procedure set_Attributes(plAttributes: Integer);
    property Value: OleVariant read get_Value write set_Value;
    property Name: WideString read get_Name;
    property Type_: DataTypeEnum read get_Type_;
    property Attributes: Integer read get_Attributes write set_Attributes;
  end;

// *********************************************************************//
// DispIntf:  Property_Disp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000503-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  Property_Disp = interface
    ['{00000503-0000-0010-8000-00AA006D2EA4}']
    property Value: OleVariant dispid 0;
    property Name: WideString readonly dispid 1610743810;
    property Type_: DataTypeEnum readonly dispid 1610743811;
    property Attributes: Integer dispid 1610743812;
  end;
*)
// *********************************************************************//
// Interface: Error
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000500-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000500-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  Error = interface { (IDispatch) }
    function get_Number: Integer;
    function get_Source: WideString;
    function get_Description: WideString;
    function get_HelpFile: WideString;
    function get_HelpContext: Integer;
    function get_SQLState: WideString;
    function get_NativeError: Integer;
    property Number: Integer read get_Number;
    property Source: WideString read get_Source;
    property Description: WideString read get_Description;
    property HelpFile: WideString read get_HelpFile;
    property HelpContext: Integer read get_HelpContext;
    property SQLState: WideString read get_SQLState;
    property NativeError: Integer read get_NativeError;
  end;

// *********************************************************************//
// DispIntf:  ErrorDisp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000500-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  ErrorDisp = interface
    ['{00000500-0000-0010-8000-00AA006D2EA4}']
    property Number: Integer readonly dispid 1610743808;
    property Source: WideString readonly dispid 1610743809;
    property Description: WideString readonly dispid 0;
    property HelpFile: WideString readonly dispid 1610743811;
    property HelpContext: Integer readonly dispid 1610743812;
    property SQLState: WideString readonly dispid 1610743813;
    property NativeError: Integer readonly dispid 1610743814;
  end;
*)
// *********************************************************************//
// Interface: Errors
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000501-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000501-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  Errors = interface { (_Collection) }
    // _Collection
    function get_Count: Integer;
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function _NewEnum: TObject; // IUnknown
    procedure Refresh;
    property Count: Integer read get_Count;

    // Errors
    function get_Item(Index: OleVariant): Error;
    procedure Clear;
    property Item[Index: OleVariant]: Error read get_Item; default;
  end;

// *********************************************************************//
// DispIntf:  ErrorsDisp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000501-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  ErrorsDisp = interface
    ['{00000501-0000-0010-8000-00AA006D2EA4}']
    property Item[Index: OleVariant]: Error readonly dispid 0; default;
    procedure Clear; dispid 1610809345;
    property Count: Integer readonly dispid 1610743808;
    function _NewEnum: IUnknown; dispid -4;
    procedure Refresh; dispid 1610743810;
  end;
*)
// *********************************************************************//
// Interface: Command15
// Flags:     (4560) Hidden Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000508-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000508-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  Command15 = interface { (_ADO) }
    // _ADO
    function get_Properties: Properties;
    property Properties: Properties read get_Properties;

    // Command15
    function get_ActiveConnection: _Connection;
    procedure set_ActiveConnection(const ppvObject: _Connection);
    procedure _set_ActiveConnection(ppvObject: OleVariant);
    function get_CommandText: WideString;
    procedure set_CommandText(const pbstr: WideString);
    function get_CommandTimeout: Integer;
    procedure set_CommandTimeout(pl: Integer);
    function get_Prepared: WordBool;
    procedure set_Prepared(pfPrepared: WordBool);
    function Execute(out RecordsAffected: OleVariant; [in] var Parameters: OleVariant; Options: Integer): _Recordset;
    function CreateParameter(const Name: WideString; Type_: DataTypeEnum;
      Direction: ParameterDirectionEnum; Size: Integer; Value: OleVariant): _Parameter;
    function get_Parameters: Parameters;
    procedure set_CommandType(plCmdType: CommandTypeEnum);
    function get_CommandType: CommandTypeEnum;
    function get_Name: WideString;
    procedure set_Name(const pbstrName: WideString);
    property CommandText: WideString read get_CommandText write set_CommandText;
    property CommandTimeout: Integer read get_CommandTimeout write set_CommandTimeout;
    property Prepared: WordBool read get_Prepared write set_Prepared;
    property Parameters: Parameters read get_Parameters;
    property CommandType: CommandTypeEnum read get_CommandType write set_CommandType;
    property Name: WideString read get_Name write set_Name;
  end;

// *********************************************************************//
// DispIntf:  Command15Disp
// Flags:     (4560) Hidden Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000508-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  Command15Disp = interface
    ['{00000508-0000-0010-8000-00AA006D2EA4}']
    function ActiveConnection: _Connection; dispid 1610809344;
    property CommandText: WideString dispid 1610809347;
    property CommandTimeout: Integer dispid 1610809349;
    property Prepared: WordBool dispid 1610809351;
    function Execute(out RecordsAffected: OleVariant; const Parameters: OleVariant; Options: Integer): _Recordset; dispid 1610809353;
    function CreateParameter(const Name: WideString; Type_: DataTypeEnum; 
      Direction: ParameterDirectionEnum; Size: Integer; Value: OleVariant): _Parameter; dispid 1610809354;
    property Parameters: Parameters readonly dispid 0;
    property CommandType: CommandTypeEnum dispid 1610809356;
    property Name: WideString dispid 1610809358;
    property Properties: Properties readonly dispid 500;
  end;
*)
// *********************************************************************//
// Interface: Connection15
// Flags:     (4432) Hidden Dual OleAutomation Dispatchable
// GUID:      {00000515-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000515-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  Connection15 = interface { (_ADO) }
    // _ADO
    function get_Properties: Properties;
    property Properties: Properties read get_Properties;

    // Connection15
    function get_ConnectionString: WideString;
    procedure set_ConnectionString(const pbstr: WideString);
    function get_CommandTimeout: Integer;
    procedure set_CommandTimeout(plTimeout: Integer);
    function get_ConnectionTimeout: Integer;
    procedure set_ConnectionTimeout(plTimeout: Integer);
    function get_Version: WideString;
    procedure Close;
    function Execute(const CommandText: WideString; out RecordsAffected: OleVariant;
      Options: Integer): _Recordset;
    function BeginTrans: Integer;
    procedure CommitTrans;
    procedure RollbackTrans;
    procedure Open(const ConnectionString: WideString; const UserID: WideString;
      const Password: WideString; Options: Integer);
    function get_Errors: Errors;
    function get_DefaultDatabase: WideString;
    procedure set_DefaultDatabase(const pbstr: WideString);
    function get_IsolationLevel: IsolationLevelEnum;
    procedure set_IsolationLevel(Level: IsolationLevelEnum);
    function get_Attributes: Integer;
    procedure set_Attributes(plAttr: Integer);
    function get_CursorLocation: CursorLocationEnum;
    procedure set_CursorLocation(plCursorLoc: CursorLocationEnum);
    function get_Mode: ConnectModeEnum;
    procedure set_Mode(plMode: ConnectModeEnum);
    function get_Provider: WideString;
    procedure set_Provider(const pbstr: WideString);
    function get_State: Integer;
    function OpenSchema(Schema: SchemaEnum; Restrictions: OleVariant; SchemaID: OleVariant): _Recordset;
    property ConnectionString: WideString read get_ConnectionString write set_ConnectionString;
    property CommandTimeout: Integer read get_CommandTimeout write set_CommandTimeout;
    property ConnectionTimeout: Integer read get_ConnectionTimeout write set_ConnectionTimeout;
    property Version: WideString read get_Version;
    property Errors: Errors read get_Errors;
    property DefaultDatabase: WideString read get_DefaultDatabase write set_DefaultDatabase;
    property IsolationLevel: IsolationLevelEnum read get_IsolationLevel write set_IsolationLevel;
    property Attributes: Integer read get_Attributes write set_Attributes;
    property CursorLocation: CursorLocationEnum read get_CursorLocation write set_CursorLocation;
    property Mode: ConnectModeEnum read get_Mode write set_Mode;
    property Provider: WideString read get_Provider write set_Provider;
    property State: Integer read get_State;
  end;

// *********************************************************************//
// DispIntf:  Connection15Disp
// Flags:     (4432) Hidden Dual OleAutomation Dispatchable
// GUID:      {00000515-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  Connection15Disp = interface
    ['{00000515-0000-0010-8000-00AA006D2EA4}']
    property ConnectionString: WideString dispid 0;
    property CommandTimeout: Integer dispid 2;
    property ConnectionTimeout: Integer dispid 3;
    property Version: WideString readonly dispid 4;
    procedure Close; dispid 5;
    function Execute(const CommandText: WideString; out RecordsAffected: OleVariant; 
      Options: Integer): _Recordset; dispid 6;
    function BeginTrans: Integer; dispid 7;
    procedure CommitTrans; dispid 8;
    procedure RollbackTrans; dispid 9;
    procedure Open(const ConnectionString: WideString; const UserID: WideString;
      const Password: WideString; Options: Integer); dispid 10;
    property Errors: Errors readonly dispid 11;
    property DefaultDatabase: WideString dispid 12;
    property IsolationLevel: IsolationLevelEnum dispid 13;
    property Attributes: Integer dispid 14;
    property CursorLocation: CursorLocationEnum dispid 15;
    property Mode: ConnectModeEnum dispid 16;
    property Provider: WideString dispid 17;
    property State: Integer readonly dispid 18;
    function OpenSchema(Schema: SchemaEnum; Restrictions: OleVariant; SchemaID: OleVariant): _Recordset; dispid 19;
    property Properties: Properties readonly dispid 500;
  end;
*)
// *********************************************************************//
// Interface: _Connection
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {00000550-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000550-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  _Connection = interface { (Connection15) }
    // _ADO
    function get_Properties: Properties;
    property Properties: Properties read get_Properties;

    // Connection15
    function get_ConnectionString: WideString;
    procedure set_ConnectionString(const pbstr: WideString);
    function get_CommandTimeout: Integer;
    procedure set_CommandTimeout(plTimeout: Integer);
    function get_ConnectionTimeout: Integer;
    procedure set_ConnectionTimeout(plTimeout: Integer);
    function get_Version: WideString;
    procedure Close;
    function Execute(const CommandText: WideString; out RecordsAffected: OleVariant;
      Options: Integer): _Recordset;
    function BeginTrans: Integer;
    procedure CommitTrans;
    procedure RollbackTrans;
    procedure Open(const ConnectionString: WideString; const UserID: WideString;
      const Password: WideString; Options: Integer);
    function get_Errors: Errors;
    function get_DefaultDatabase: WideString;
    procedure set_DefaultDatabase(const pbstr: WideString);
    function get_IsolationLevel: IsolationLevelEnum;
    procedure set_IsolationLevel(Level: IsolationLevelEnum);
    function get_Attributes: Integer;
    procedure set_Attributes(plAttr: Integer);
    function get_CursorLocation: CursorLocationEnum;
    procedure set_CursorLocation(plCursorLoc: CursorLocationEnum);
    function get_Mode: ConnectModeEnum;
    procedure set_Mode(plMode: ConnectModeEnum);
    function get_Provider: WideString;
    procedure set_Provider(const pbstr: WideString);
    function get_State: Integer;
    function OpenSchema(Schema: SchemaEnum; Restrictions: OleVariant; SchemaID: OleVariant): _Recordset;
    property ConnectionString: WideString read get_ConnectionString write set_ConnectionString;
    property CommandTimeout: Integer read get_CommandTimeout write set_CommandTimeout;
    property ConnectionTimeout: Integer read get_ConnectionTimeout write set_ConnectionTimeout;
    property Version: WideString read get_Version;
    property Errors: Errors read get_Errors;
    property DefaultDatabase: WideString read get_DefaultDatabase write set_DefaultDatabase;
    property IsolationLevel: IsolationLevelEnum read get_IsolationLevel write set_IsolationLevel;
    property Attributes: Integer read get_Attributes write set_Attributes;
    property CursorLocation: CursorLocationEnum read get_CursorLocation write set_CursorLocation;
    property Mode: ConnectModeEnum read get_Mode write set_Mode;
    property Provider: WideString read get_Provider write set_Provider;
    property State: Integer read get_State;

    // _Connection
    procedure Cancel;
  end;
(*
// *********************************************************************//
// DispIntf:  _ConnectionDisp
// Flags:     (4416) Dual OleAutomation Dispatchable
// GUID:      {00000550-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  _ConnectionDisp = interface
    ['{00000550-0000-0010-8000-00AA006D2EA4}']
    procedure Cancel; dispid 21;
    property ConnectionString: WideString dispid 0;
    property CommandTimeout: Integer dispid 2;
    property ConnectionTimeout: Integer dispid 3;
    property Version: WideString readonly dispid 4;
    procedure Close; dispid 5;
    function Execute(const CommandText: WideString; out RecordsAffected: OleVariant;
      Options: Integer): _Recordset; dispid 6;
    function BeginTrans: Integer; dispid 7;
    procedure CommitTrans; dispid 8;
    procedure RollbackTrans; dispid 9;
    procedure Open(const ConnectionString: WideString; const UserID: WideString;
      const Password: WideString; Options: Integer); dispid 10;
    property Errors: Errors readonly dispid 11;
    property DefaultDatabase: WideString dispid 12;
    property IsolationLevel: IsolationLevelEnum dispid 13;
    property Attributes: Integer dispid 14;
    property CursorLocation: CursorLocationEnum dispid 15;
    property Mode: ConnectModeEnum dispid 16;
    property Provider: WideString dispid 17;
    property State: Integer readonly dispid 18;
    function OpenSchema(Schema: SchemaEnum; Restrictions: OleVariant; SchemaID: OleVariant): _Recordset; dispid 19;
    property Properties: Properties readonly dispid 500;
  end;
*)
// *********************************************************************//
// Interface: Recordset15
// Flags:     (4560) Hidden Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000050E-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0000050E-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  Recordset15 = interface { (_ADO) }
    // _ADO
    function get_Properties: Properties;
    property Properties: Properties read get_Properties;

    // Recordset15
    function get_AbsolutePosition: PositionEnum;
    procedure set_AbsolutePosition(pl: PositionEnum);
    procedure set_ActiveConnection([MarshalAs(UnmanagedType.IDispatch)] const pvar: TObject);
    procedure _set_ActiveConnection(pvar: OleVariant);
    function get_ActiveConnection: OleVariant;
    function get_BOF: WordBool;
    function get_Bookmark: OleVariant;
    procedure set_Bookmark(pvBookmark: OleVariant);
    function get_CacheSize: Integer;
    procedure set_CacheSize(pl: Integer);
    function get_CursorType: CursorTypeEnum;
    procedure set_CursorType(plCursorType: CursorTypeEnum);
    function get_EOF: WordBool;
    function get_Fields: Fields;
    function get_LockType: LockTypeEnum;
    procedure set_LockType(plLockType: LockTypeEnum);
    function get_MaxRecords: Integer;
    procedure set_MaxRecords(plMaxRecords: Integer);
    function get_RecordCount: Integer;
    procedure set_Source([MarshalAs(UnmanagedType.IDispatch)] const pvSource: TObject);
    procedure _set_Source(const pvSource: WideString);
    function get_Source: OleVariant;
    procedure AddNew(FieldList: OleVariant; Values: OleVariant);
    procedure CancelUpdate;
    procedure Close;
    procedure Delete(AffectRecords: AffectEnum);
    function GetRows(Rows: Integer; Start: OleVariant; Fields: OleVariant): OleVariant; 
    procedure Move(NumRecords: Integer; Start: OleVariant);
    procedure MoveNext;
    procedure MovePrevious;
    procedure MoveFirst;
    procedure MoveLast;
    procedure Open(Source: OleVariant; ActiveConnection: OleVariant; CursorType: CursorTypeEnum;
      LockType: LockTypeEnum; Options: Integer);
    procedure Requery(Options: Integer);
    procedure _xResync(AffectRecords: AffectEnum);
    procedure Update(Fields: OleVariant; Values: OleVariant);
    function get_AbsolutePage: PositionEnum;
    procedure set_AbsolutePage(pl: PositionEnum);
    function get_EditMode: EditModeEnum;
    function get_Filter: OleVariant;
    procedure set_Filter(Criteria: OleVariant);
    function get_PageCount: Integer;
    function get_PageSize: Integer;
    procedure set_PageSize(pl: Integer);
    function get_Sort: WideString;
    procedure set_Sort(const Criteria: WideString);
    function get_Status: Integer;
    function get_State: Integer;
    function _xClone: _Recordset;
    procedure UpdateBatch(AffectRecords: AffectEnum);
    procedure CancelBatch(AffectRecords: AffectEnum);
    function get_CursorLocation: CursorLocationEnum;
    procedure set_CursorLocation(plCursorLoc: CursorLocationEnum);
    function NextRecordset(out RecordsAffected: OleVariant): _Recordset;
    function Supports(CursorOptions: CursorOptionEnum): WordBool;
    function get_Collect(Index: OleVariant): OleVariant;
    procedure set_Collect(Index: OleVariant; pvar: OleVariant);
    function get_MarshalOptions: MarshalOptionsEnum;
    procedure set_MarshalOptions(peMarshal: MarshalOptionsEnum);
    procedure Find(const Criteria: WideString; SkipRecords: Integer;
      SearchDirection: SearchDirectionEnum; Start: OleVariant);
    property AbsolutePosition: PositionEnum read get_AbsolutePosition write set_AbsolutePosition;
    property BOF: WordBool read get_BOF;
    property Bookmark: OleVariant read get_Bookmark write set_Bookmark;
    property CacheSize: Integer read get_CacheSize write set_CacheSize;
    property CursorType: CursorTypeEnum read get_CursorType write set_CursorType;
    property EOF: WordBool read get_EOF;
    property Fields: Fields read get_Fields;
    property LockType: LockTypeEnum read get_LockType write set_LockType;
    property MaxRecords: Integer read get_MaxRecords write set_MaxRecords;
    property RecordCount: Integer read get_RecordCount;
    property AbsolutePage: PositionEnum read get_AbsolutePage write set_AbsolutePage;
    property EditMode: EditModeEnum read get_EditMode;
    property Filter: OleVariant read get_Filter write set_Filter;
    property PageCount: Integer read get_PageCount;
    property PageSize: Integer read get_PageSize write set_PageSize;
    property Sort: WideString read get_Sort write set_Sort;
    property Status: Integer read get_Status;
    property State: Integer read get_State;
    property CursorLocation: CursorLocationEnum read get_CursorLocation write set_CursorLocation;
    property Collect[Index: OleVariant]: OleVariant read get_Collect write set_Collect;
    property MarshalOptions: MarshalOptionsEnum read get_MarshalOptions write set_MarshalOptions;
  end;

// *********************************************************************//
// DispIntf:  Recordset15Disp
// Flags:     (4560) Hidden Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000050E-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  Recordset15Disp = interface
    ['{0000050E-0000-0010-8000-00AA006D2EA4}']
    property AbsolutePosition: PositionEnum dispid 1000;
    function ActiveConnection: IDispatch; dispid 1001;
    property BOF: WordBool readonly dispid 1002;
    property Bookmark: OleVariant dispid 1003;
    property CacheSize: Integer dispid 1004;
    property CursorType: CursorTypeEnum dispid 1005;
    property EOF: WordBool readonly dispid 1006;
    property Fields: Fields readonly dispid 0;
    property LockType: LockTypeEnum dispid 1008;
    property MaxRecords: Integer dispid 1009;
    property RecordCount: Integer readonly dispid 1010;
    function Source: IDispatch; dispid 1011;
    procedure AddNew(FieldList: OleVariant; Values: OleVariant); dispid 1012;
    procedure CancelUpdate; dispid 1013;
    procedure Close; dispid 1014;
    procedure Delete(AffectRecords: AffectEnum); dispid 1015;
    function GetRows(Rows: Integer; Start: OleVariant; Fields: OleVariant): OleVariant; dispid 1016;
    procedure Move(NumRecords: Integer; Start: OleVariant); dispid 1017;
    procedure MoveNext; dispid 1018;
    procedure MovePrevious; dispid 1019;
    procedure MoveFirst; dispid 1020;
    procedure MoveLast; dispid 1021;
    procedure Open(Source: OleVariant; ActiveConnection: OleVariant; CursorType: CursorTypeEnum;
      LockType: LockTypeEnum; Options: Integer); dispid 1022;
    procedure Requery(Options: Integer); dispid 1023;
    procedure _xResync(AffectRecords: AffectEnum); dispid 1610809378;
    procedure Update(Fields: OleVariant; Values: OleVariant); dispid 1025;
    property AbsolutePage: PositionEnum dispid 1047;
    property EditMode: EditModeEnum readonly dispid 1026;
    property Filter: OleVariant dispid 1030;
    property PageCount: Integer readonly dispid 1050;
    property PageSize: Integer dispid 1048;
    property Sort: WideString dispid 1031;
    property Status: Integer readonly dispid 1029;
    property State: Integer readonly dispid 1054;
    function _xClone: _Recordset; dispid 1610809392;
    procedure UpdateBatch(AffectRecords: AffectEnum); dispid 1035;
    procedure CancelBatch(AffectRecords: AffectEnum); dispid 1049;
    property CursorLocation: CursorLocationEnum dispid 1051;
    function NextRecordset(out RecordsAffected: OleVariant): _Recordset; dispid 1052;
    function Supports(CursorOptions: CursorOptionEnum): WordBool; dispid 1036;
    property Collect[Index: OleVariant]: OleVariant dispid -8;
    property MarshalOptions: MarshalOptionsEnum dispid 1053;
    procedure Find(const Criteria: WideString; SkipRecords: Integer;
      SearchDirection: SearchDirectionEnum; Start: OleVariant); dispid 1058;
    property Properties: Properties readonly dispid 500;
  end;
*)
// *********************************************************************//
// Interface: Recordset20
// Flags:     (4560) Hidden Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000054F-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0000054F-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  Recordset20 = interface { (Recordset15) }
    // _ADO
    function get_Properties: Properties;
    property Properties: Properties read get_Properties;

    // Recordset15
    function get_AbsolutePosition: PositionEnum;
    procedure set_AbsolutePosition(pl: PositionEnum);
    procedure set_ActiveConnection([MarshalAs(UnmanagedType.IDispatch)] const pvar: TObject);
    procedure _set_ActiveConnection(pvar: OleVariant);
    function get_ActiveConnection: OleVariant;
    function get_BOF: WordBool;
    function get_Bookmark: OleVariant;
    procedure set_Bookmark(pvBookmark: OleVariant);
    function get_CacheSize: Integer;
    procedure set_CacheSize(pl: Integer);
    function get_CursorType: CursorTypeEnum;
    procedure set_CursorType(plCursorType: CursorTypeEnum);
    function get_EOF: WordBool;
    function get_Fields: Fields;
    function get_LockType: LockTypeEnum;
    procedure set_LockType(plLockType: LockTypeEnum);
    function get_MaxRecords: Integer;
    procedure set_MaxRecords(plMaxRecords: Integer);
    function get_RecordCount: Integer;
    procedure set_Source([MarshalAs(UnmanagedType.IDispatch)] const pvSource: TObject);
    procedure _set_Source(const pvSource: WideString);
    function get_Source: OleVariant;
    procedure AddNew(FieldList: OleVariant; Values: OleVariant);
    procedure CancelUpdate;
    procedure Close;
    procedure Delete(AffectRecords: AffectEnum);
    function GetRows(Rows: Integer; Start: OleVariant; Fields: OleVariant): OleVariant; 
    procedure Move(NumRecords: Integer; Start: OleVariant);
    procedure MoveNext;
    procedure MovePrevious;
    procedure MoveFirst;
    procedure MoveLast;
    procedure Open(Source: OleVariant; ActiveConnection: OleVariant; CursorType: CursorTypeEnum;
      LockType: LockTypeEnum; Options: Integer);
    procedure Requery(Options: Integer);
    procedure _xResync(AffectRecords: AffectEnum);
    procedure Update(Fields: OleVariant; Values: OleVariant);
    function get_AbsolutePage: PositionEnum;
    procedure set_AbsolutePage(pl: PositionEnum);
    function get_EditMode: EditModeEnum;
    function get_Filter: OleVariant;
    procedure set_Filter(Criteria: OleVariant);
    function get_PageCount: Integer;
    function get_PageSize: Integer;
    procedure set_PageSize(pl: Integer);
    function get_Sort: WideString;
    procedure set_Sort(const Criteria: WideString);
    function get_Status: Integer;
    function get_State: Integer;
    function _xClone: _Recordset;
    procedure UpdateBatch(AffectRecords: AffectEnum);
    procedure CancelBatch(AffectRecords: AffectEnum);
    function get_CursorLocation: CursorLocationEnum;
    procedure set_CursorLocation(plCursorLoc: CursorLocationEnum);
    function NextRecordset(out RecordsAffected: OleVariant): _Recordset;
    function Supports(CursorOptions: CursorOptionEnum): WordBool;
    function get_Collect(Index: OleVariant): OleVariant;
    procedure set_Collect(Index: OleVariant; pvar: OleVariant);
    function get_MarshalOptions: MarshalOptionsEnum;
    procedure set_MarshalOptions(peMarshal: MarshalOptionsEnum);
    procedure Find(const Criteria: WideString; SkipRecords: Integer;
      SearchDirection: SearchDirectionEnum; Start: OleVariant);
    property AbsolutePosition: PositionEnum read get_AbsolutePosition write set_AbsolutePosition;
    property BOF: WordBool read get_BOF;
    property Bookmark: OleVariant read get_Bookmark write set_Bookmark;
    property CacheSize: Integer read get_CacheSize write set_CacheSize;
    property CursorType: CursorTypeEnum read get_CursorType write set_CursorType;
    property EOF: WordBool read get_EOF;
    property Fields: Fields read get_Fields;
    property LockType: LockTypeEnum read get_LockType write set_LockType;
    property MaxRecords: Integer read get_MaxRecords write set_MaxRecords;
    property RecordCount: Integer read get_RecordCount;
    property AbsolutePage: PositionEnum read get_AbsolutePage write set_AbsolutePage;
    property EditMode: EditModeEnum read get_EditMode;
    property Filter: OleVariant read get_Filter write set_Filter;
    property PageCount: Integer read get_PageCount;
    property PageSize: Integer read get_PageSize write set_PageSize;
    property Sort: WideString read get_Sort write set_Sort;
    property Status: Integer read get_Status;
    property State: Integer read get_State;
    property CursorLocation: CursorLocationEnum read get_CursorLocation write set_CursorLocation;
    property Collect[Index: OleVariant]: OleVariant read get_Collect write set_Collect;
    property MarshalOptions: MarshalOptionsEnum read get_MarshalOptions write set_MarshalOptions;

    // Recordset20
    procedure Cancel;
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function get_DataSource: TObject; // IUnknown
    procedure set_DataSource([in, MarshalAs(UnmanagedType.IUnknown)] ppunkDataSource: TObject);
    procedure Save(const FileName: WideString; PersistFormat: PersistFormatEnum);
    [result: MarshalAs(UnmanagedType.IDispatch)]
    function get_ActiveCommand: TObject; // IDispatch
    procedure set_StayInSync(pbStayInSync: WordBool);
    function get_StayInSync: WordBool;
    function GetString(StringFormat: StringFormatEnum; NumRows: Integer;
      const ColumnDelimeter: WideString; const RowDelimeter: WideString;
      const NullExpr: WideString): WideString;
    function get_DataMember: WideString;
    procedure set_DataMember(const pbstrDataMember: WideString);
    function CompareBookmarks(Bookmark1: OleVariant; Bookmark2: OleVariant): CompareEnum;
    function Clone(LockType: LockTypeEnum): _Recordset;
    procedure Resync(AffectRecords: AffectEnum; ResyncValues: ResyncEnum);
    property DataSource: TObject read get_DataSource write set_DataSource;
    property ActiveCommand: TObject read get_ActiveCommand;
    property StayInSync: WordBool read get_StayInSync write set_StayInSync;
    property DataMember: WideString read get_DataMember write set_DataMember;
  end;

// *********************************************************************//
// DispIntf:  Recordset20Disp
// Flags:     (4560) Hidden Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000054F-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  Recordset20Disp = interface
    ['{0000054F-0000-0010-8000-00AA006D2EA4}']
    procedure Cancel; dispid 1055;
    property DataSource: IUnknown dispid 1056;
    procedure Save(const FileName: WideString; PersistFormat: PersistFormatEnum); dispid 1057;
    property ActiveCommand: IDispatch readonly dispid 1061;
    property StayInSync: WordBool dispid 1063;
    function GetString(StringFormat: StringFormatEnum; NumRows: Integer;
      const ColumnDelimeter: WideString; const RowDelimeter: WideString;
      const NullExpr: WideString): WideString; dispid 1062;
    property DataMember: WideString dispid 1064;
    function CompareBookmarks(Bookmark1: OleVariant; Bookmark2: OleVariant): CompareEnum; dispid 1065;
    function Clone(LockType: LockTypeEnum): _Recordset; dispid 1034;
    procedure Resync(AffectRecords: AffectEnum; ResyncValues: ResyncEnum); dispid 1024;
    property AbsolutePosition: PositionEnum dispid 1000;
    function ActiveConnection: IDispatch; dispid 1001;
    property BOF: WordBool readonly dispid 1002;
    property Bookmark: OleVariant dispid 1003;
    property CacheSize: Integer dispid 1004;
    property CursorType: CursorTypeEnum dispid 1005;
    property EOF: WordBool readonly dispid 1006;
    property Fields: Fields readonly dispid 0;
    property LockType: LockTypeEnum dispid 1008;
    property MaxRecords: Integer dispid 1009;
    property RecordCount: Integer readonly dispid 1010;
    function Source: IDispatch; dispid 1011;
    procedure AddNew(FieldList: OleVariant; Values: OleVariant); dispid 1012;
    procedure CancelUpdate; dispid 1013;
    procedure Close; dispid 1014;
    procedure Delete(AffectRecords: AffectEnum); dispid 1015;
    function GetRows(Rows: Integer; Start: OleVariant; Fields: OleVariant): OleVariant; dispid 1016;
    procedure Move(NumRecords: Integer; Start: OleVariant); dispid 1017;
    procedure MoveNext; dispid 1018;
    procedure MovePrevious; dispid 1019;
    procedure MoveFirst; dispid 1020;
    procedure MoveLast; dispid 1021;
    procedure Open(Source: OleVariant; ActiveConnection: OleVariant; CursorType: CursorTypeEnum;
      LockType: LockTypeEnum; Options: Integer); dispid 1022;
    procedure Requery(Options: Integer); dispid 1023;
    procedure _xResync(AffectRecords: AffectEnum); dispid 1610809378;
    procedure Update(Fields: OleVariant; Values: OleVariant); dispid 1025;
    property AbsolutePage: PositionEnum dispid 1047;
    property EditMode: EditModeEnum readonly dispid 1026;
    property Filter: OleVariant dispid 1030;
    property PageCount: Integer readonly dispid 1050;
    property PageSize: Integer dispid 1048;
    property Sort: WideString dispid 1031;
    property Status: Integer readonly dispid 1029;
    property State: Integer readonly dispid 1054;
    function _xClone: _Recordset; dispid 1610809392;
    procedure UpdateBatch(AffectRecords: AffectEnum); dispid 1035;
    procedure CancelBatch(AffectRecords: AffectEnum); dispid 1049;
    property CursorLocation: CursorLocationEnum dispid 1051;
    function NextRecordset(out RecordsAffected: OleVariant): _Recordset; dispid 1052;
    function Supports(CursorOptions: CursorOptionEnum): WordBool; dispid 1036;
    property Collect[Index: OleVariant]: OleVariant dispid -8;
    property MarshalOptions: MarshalOptionsEnum dispid 1053;
    procedure Find(const Criteria: WideString; SkipRecords: Integer; 
      SearchDirection: SearchDirectionEnum; Start: OleVariant); dispid 1058;
    property Properties: Properties readonly dispid 500;
  end;
*)
// *********************************************************************//
// Interface: _Recordset
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000555-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000555-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  _Recordset = interface { (Recordset20) }
    // _ADO
    function get_Properties: Properties;
    property Properties: Properties read get_Properties;

    // Recordset15
    function get_AbsolutePosition: PositionEnum;
    procedure set_AbsolutePosition(pl: PositionEnum);
    procedure set_ActiveConnection([MarshalAs(UnmanagedType.IDispatch)] const pvar: TObject);
    procedure _set_ActiveConnection(pvar: OleVariant);
    function get_ActiveConnection: OleVariant;
    function get_BOF: WordBool;
    function get_Bookmark: TOleVarData; //OleVariant;
    procedure set_Bookmark(pvBookmark: TOleVarData{OleVariant});
    function get_CacheSize: Integer;
    procedure set_CacheSize(pl: Integer);
    function get_CursorType: CursorTypeEnum;
    procedure set_CursorType(plCursorType: CursorTypeEnum);
    function get_EOF: WordBool;
    function get_Fields: Fields;
    function get_LockType: LockTypeEnum;
    procedure set_LockType(plLockType: LockTypeEnum);
    function get_MaxRecords: Integer;
    procedure set_MaxRecords(plMaxRecords: Integer);
    function get_RecordCount: Integer;
    procedure set_Source(const pvSource: TObject {IDispatch});
    procedure _set_Source(const pvSource: WideString);
    function get_Source: OleVariant;
    procedure AddNew(FieldList: OleVariant; Values: OleVariant);
    procedure CancelUpdate;
    procedure Close;
    procedure Delete(AffectRecords: AffectEnum);
    function GetRows(Rows: Integer; Start: OleVariant; Fields: OleVariant): OleVariant; 
    procedure Move(NumRecords: Integer; Start: OleVariant);
    procedure MoveNext;
    procedure MovePrevious;
    procedure MoveFirst;
    procedure MoveLast;
    procedure Open(Source: OleVariant; ActiveConnection: OleVariant; CursorType: CursorTypeEnum;
      LockType: LockTypeEnum; Options: Integer);
    procedure Requery(Options: Integer);
    procedure _xResync(AffectRecords: AffectEnum);
    procedure Update(Fields: OleVariant; Values: OleVariant);
    function get_AbsolutePage: PositionEnum;
    procedure set_AbsolutePage(pl: PositionEnum);
    function get_EditMode: EditModeEnum;
    function get_Filter: OleVariant;
    procedure set_Filter(Criteria: OleVariant);
    function get_PageCount: Integer;
    function get_PageSize: Integer;
    procedure set_PageSize(pl: Integer);
    function get_Sort: WideString;
    procedure set_Sort(const Criteria: WideString);
    function get_Status: Integer;
    function get_State: Integer;
    function _xClone: _Recordset;
    procedure UpdateBatch(AffectRecords: AffectEnum);
    procedure CancelBatch(AffectRecords: AffectEnum);
    function get_CursorLocation: CursorLocationEnum;
    procedure set_CursorLocation(plCursorLoc: CursorLocationEnum);
    function NextRecordset(out RecordsAffected: OleVariant): _Recordset;
    function Supports(CursorOptions: CursorOptionEnum): WordBool;
    function get_Collect(Index: OleVariant): OleVariant;
    procedure set_Collect(Index: OleVariant; pvar: OleVariant);
    function get_MarshalOptions: MarshalOptionsEnum;
    procedure set_MarshalOptions(peMarshal: MarshalOptionsEnum);
    procedure Find(const Criteria: WideString; SkipRecords: Integer;
      SearchDirection: SearchDirectionEnum; Start: OleVariant);
    property AbsolutePosition: PositionEnum read get_AbsolutePosition write set_AbsolutePosition;
    property BOF: WordBool read get_BOF;
    property Bookmark: TOleVarData {OleVariant} read get_Bookmark write set_Bookmark;
    property CacheSize: Integer read get_CacheSize write set_CacheSize;
    property CursorType: CursorTypeEnum read get_CursorType write set_CursorType;
    property EOF: WordBool read get_EOF;
    property Fields: Fields read get_Fields;
    property LockType: LockTypeEnum read get_LockType write set_LockType;
    property MaxRecords: Integer read get_MaxRecords write set_MaxRecords;
    property RecordCount: Integer read get_RecordCount;
    property AbsolutePage: PositionEnum read get_AbsolutePage write set_AbsolutePage;
    property EditMode: EditModeEnum read get_EditMode;
    property Filter: OleVariant read get_Filter write set_Filter;
    property PageCount: Integer read get_PageCount;
    property PageSize: Integer read get_PageSize write set_PageSize;
    property Sort: WideString read get_Sort write set_Sort;
    property Status: Integer read get_Status;
    property State: Integer read get_State;
    property CursorLocation: CursorLocationEnum read get_CursorLocation write set_CursorLocation;
    property Collect[Index: OleVariant]: OleVariant read get_Collect write set_Collect;
    property MarshalOptions: MarshalOptionsEnum read get_MarshalOptions write set_MarshalOptions;

    // Recordset20
    procedure Cancel;
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function get_DataSource: TObject; // IUnknown
    procedure set_DataSource([in, MarshalAs(UnmanagedType.IUnknown)] ppunkDataSource: TObject);
    procedure Save(const FileName: WideString; PersistFormat: PersistFormatEnum);
    [result: MarshalAs(UnmanagedType.IDispatch)]
    function get_ActiveCommand: TObject; // IDispatch
    procedure set_StayInSync(pbStayInSync: WordBool);
    function get_StayInSync: WordBool;
    function GetString(StringFormat: StringFormatEnum; NumRows: Integer;
      const ColumnDelimeter: WideString; const RowDelimeter: WideString;
      const NullExpr: WideString): WideString;
    function get_DataMember: WideString;
    procedure set_DataMember(const pbstrDataMember: WideString);
    function CompareBookmarks(Bookmark1: TOleVarData{OleVariant}; Bookmark2: TOleVarData {OleVariant}): CompareEnum;
    function Clone(LockType: LockTypeEnum): _Recordset;
    procedure Resync(AffectRecords: AffectEnum; ResyncValues: ResyncEnum);
    property DataSource: TObject read get_DataSource write set_DataSource;
    property ActiveCommand: TObject read get_ActiveCommand;
    property StayInSync: WordBool read get_StayInSync write set_StayInSync;
    property DataMember: WideString read get_DataMember write set_DataMember;

    // _Recordset
    procedure Seek(KeyValues: OleVariant; SeekOption: SeekEnum);
    procedure set_Index(const pbstrIndex: WideString);
    function get_Index: WideString;
    property Index: WideString read get_Index write set_Index;
  end;

// *********************************************************************//
// DispIntf:  _RecordsetDisp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000555-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  _RecordsetDisp = interface
    ['{00000555-0000-0010-8000-00AA006D2EA4}']
    procedure Seek(KeyValues: OleVariant; SeekOption: SeekEnum); dispid 1066;
    property Index: WideString dispid 1067;
    procedure Cancel; dispid 1055;
    property DataSource: IUnknown dispid 1056;
    procedure Save(const FileName: WideString; PersistFormat: PersistFormatEnum); dispid 1057;
    property ActiveCommand: IDispatch readonly dispid 1061;
    property StayInSync: WordBool dispid 1063;
    function GetString(StringFormat: StringFormatEnum; NumRows: Integer;
      const ColumnDelimeter: WideString; const RowDelimeter: WideString;
      const NullExpr: WideString): WideString; dispid 1062;
    property DataMember: WideString dispid 1064;
    function CompareBookmarks(Bookmark1: OleVariant; Bookmark2: OleVariant): CompareEnum; dispid 1065;
    function Clone(LockType: LockTypeEnum): _Recordset; dispid 1034;
    procedure Resync(AffectRecords: AffectEnum; ResyncValues: ResyncEnum); dispid 1024;
    property AbsolutePosition: PositionEnum dispid 1000;
    function ActiveConnection: IDispatch; dispid 1001;
    property BOF: WordBool readonly dispid 1002;
    property Bookmark: OleVariant dispid 1003;
    property CacheSize: Integer dispid 1004;
    property CursorType: CursorTypeEnum dispid 1005;
    property EOF: WordBool readonly dispid 1006;
    property Fields: Fields readonly dispid 0;
    property LockType: LockTypeEnum dispid 1008;
    property MaxRecords: Integer dispid 1009;
    property RecordCount: Integer readonly dispid 1010;
    function Source: IDispatch; dispid 1011;
    procedure AddNew(FieldList: OleVariant; Values: OleVariant); dispid 1012;
    procedure CancelUpdate; dispid 1013;
    procedure Close; dispid 1014;
    procedure Delete(AffectRecords: AffectEnum); dispid 1015;
    function GetRows(Rows: Integer; Start: OleVariant; Fields: OleVariant): OleVariant; dispid 1016;
    procedure Move(NumRecords: Integer; Start: OleVariant); dispid 1017;
    procedure MoveNext; dispid 1018;
    procedure MovePrevious; dispid 1019;
    procedure MoveFirst; dispid 1020;
    procedure MoveLast; dispid 1021;
    procedure Open(Source: OleVariant; ActiveConnection: OleVariant; CursorType: CursorTypeEnum;
      LockType: LockTypeEnum; Options: Integer); dispid 1022;
    procedure Requery(Options: Integer); dispid 1023;
    procedure _xResync(AffectRecords: AffectEnum); dispid 1610809378;
    procedure Update(Fields: OleVariant; Values: OleVariant); dispid 1025;
    property AbsolutePage: PositionEnum dispid 1047;
    property EditMode: EditModeEnum readonly dispid 1026;
    property Filter: OleVariant dispid 1030;
    property PageCount: Integer readonly dispid 1050;
    property PageSize: Integer dispid 1048;
    property Sort: WideString dispid 1031;
    property Status: Integer readonly dispid 1029;
    property State: Integer readonly dispid 1054;
    function _xClone: _Recordset; dispid 1610809392;
    procedure UpdateBatch(AffectRecords: AffectEnum); dispid 1035;
    procedure CancelBatch(AffectRecords: AffectEnum); dispid 1049;
    property CursorLocation: CursorLocationEnum dispid 1051;
    function NextRecordset(out RecordsAffected: OleVariant): _Recordset; dispid 1052;
    function Supports(CursorOptions: CursorOptionEnum): WordBool; dispid 1036;
    property Collect[Index: OleVariant]: OleVariant dispid -8;
    property MarshalOptions: MarshalOptionsEnum dispid 1053;
    procedure Find(const Criteria: WideString; SkipRecords: Integer;
      SearchDirection: SearchDirectionEnum; Start: OleVariant); dispid 1058;
    property Properties: Properties readonly dispid 500;
  end;
*)
// *********************************************************************//
// Interface: Fields15
// Flags:     (4560) Hidden Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000506-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000506-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  Fields15 = interface { (_Collection) }
    // _Collection
    function get_Count: Integer;
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function _NewEnum: TObject; // IUnknown
    procedure Refresh;
    property Count: Integer read get_Count;

    // Fields15
    function get_Item(Index: OleVariant): Field;
    property Item[Index: OleVariant]: Field read get_Item; default;
  end;

// *********************************************************************//
// DispIntf:  Fields15Disp
// Flags:     (4560) Hidden Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000506-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  Fields15Disp = interface
    ['{00000506-0000-0010-8000-00AA006D2EA4}']
    property Item[Index: OleVariant]: Field readonly dispid 0; default;
    property Count: Integer readonly dispid 1610743808;
    function _NewEnum: IUnknown; dispid -4;
    procedure Refresh; dispid 1610743810;
  end;
*)
// *********************************************************************//
// Interface: Fields
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000054D-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0000054D-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  Fields = interface { (Fields15) }
    // _Collection
    function get_Count: Integer;
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function _NewEnum: TObject; // IUnknown
    procedure Refresh;
    property Count: Integer read get_Count;

    // Fields15
    function get_Item(Index: OleVariant): Field;
    property Item[Index: OleVariant]: Field read get_Item; default;

    // Fields
    procedure Append(const Name: WideString; Type_: DataTypeEnum; DefinedSize: Integer;
      Attrib: FieldAttributeEnum);
    procedure Delete(Index: OleVariant);
  end;

// *********************************************************************//
// DispIntf:  FieldsDisp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000054D-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  FieldsDisp = interface
    ['{0000054D-0000-0010-8000-00AA006D2EA4}']
    procedure Append(const Name: WideString; Type_: DataTypeEnum;
      DefinedSize: Integer; Attrib: FieldAttributeEnum); dispid 1610874880;
    procedure Delete(Index: OleVariant); dispid 1610874881;
    property Item[Index: OleVariant]: Field readonly dispid 0; default;
    property Count: Integer readonly dispid 1610743808;
    function _NewEnum: IUnknown; dispid -4;
    procedure Refresh; dispid 1610743810;
  end;
*)
// *********************************************************************//
// Interface: Field
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000054C-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0000054C-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  Field = interface { (_ADO) }
    // _ADO
    function get_Properties: Properties;
    property Properties: Properties read get_Properties;

    // Field
    function get_ActualSize: Integer;
    function get_Attributes: Integer;
    function get_DefinedSize: Integer;
    function get_Name: WideString;
    function get_Type_: DataTypeEnum;
    function get_Value: TOleVarData;
    procedure set_Value(pvar: TOleVarData);
    function get_Precision: Byte;
    function get_NumericScale: Byte;
    procedure AppendChunk(Data: OleVariant);
    function GetChunk(Length: Integer): OleVariant;
    function get_OriginalValue: OleVariant;
    function get_UnderlyingValue: OleVariant;
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function get_DataFormat: TObject; // IUnknown
    procedure set_DataFormat([in, MarshalAs(UnmanagedType.IUnknown)] ppiDF: TObject);
    procedure set_Precision(pbPrecision: Byte);
    procedure set_NumericScale(pbNumericScale: Byte);
    procedure set_Type_(pDataType: DataTypeEnum);
    procedure set_DefinedSize(pl: Integer);
    procedure set_Attributes(pl: Integer);
    property ActualSize: Integer read get_ActualSize;
    property Attributes: Integer read get_Attributes write set_Attributes;
    property DefinedSize: Integer read get_DefinedSize write set_DefinedSize;
    property Name: WideString read get_Name;
    property Type_: DataTypeEnum read get_Type_ write set_Type_;
    property Value: TOleVarData read get_Value write set_Value;
    property Precision: Byte read get_Precision write set_Precision;
    property NumericScale: Byte read get_NumericScale write set_NumericScale;
    property OriginalValue: OleVariant read get_OriginalValue;
    property UnderlyingValue: OleVariant read get_UnderlyingValue;
    property DataFormat: TObject read get_DataFormat write set_DataFormat;
  end;

// *********************************************************************//
// DispIntf:  FieldDisp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000054C-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  FieldDisp = interface
    ['{0000054C-0000-0010-8000-00AA006D2EA4}']
    property ActualSize: Integer readonly dispid 1109;
    property Attributes: Integer dispid 1036;
    property DefinedSize: Integer dispid 1103;
    property Name: WideString readonly dispid 1100;
    property Type_: DataTypeEnum dispid 1102;
    property Value: OleVariant dispid 0;
    property Precision: Byte dispid 1610809351;
    property NumericScale: Byte dispid 1610809352;
    procedure AppendChunk(Data: OleVariant); dispid 1107;
    function GetChunk(Length: Integer): OleVariant; dispid 1108;
    property OriginalValue: OleVariant readonly dispid 1104;
    property UnderlyingValue: OleVariant readonly dispid 1105;
    property DataFormat: IUnknown dispid 1610809357;
    property Properties: Properties readonly dispid 500;
  end;

// *********************************************************************//
// Interface: Field15
// Flags:     (4560) Hidden Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000505-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  Field15 = interface(_ADO)
    ['{00000505-0000-0010-8000-00AA006D2EA4}']
    function get_ActualSize: Integer; safecall;
    function get_Attributes: Integer; safecall;
    function get_DefinedSize: Integer; safecall;
    function get_Name: WideString; safecall;
    function get_Type_: DataTypeEnum; safecall;
    function get_Value: OleVariant; safecall;
    procedure set_Value(pvar: OleVariant); safecall;
    function get_Precision: Byte; safecall;
    function get_NumericScale: Byte; safecall;
    procedure AppendChunk(Data: OleVariant); safecall;
    function GetChunk(Length: Integer): OleVariant; safecall;
    function get_OriginalValue: OleVariant; safecall;
    function get_UnderlyingValue: OleVariant; safecall;
    property ActualSize: Integer read get_ActualSize;
    property Attributes: Integer read get_Attributes;
    property DefinedSize: Integer read get_DefinedSize;
    property Name: WideString read get_Name;
    property Type_: DataTypeEnum read get_Type_;
    property Value: OleVariant read get_Value write set_Value;
    property Precision: Byte read get_Precision;
    property NumericScale: Byte read get_NumericScale;
    property OriginalValue: OleVariant read get_OriginalValue;
    property UnderlyingValue: OleVariant read get_UnderlyingValue;
  end;

// *********************************************************************//
// DispIntf:  Field15Disp
// Flags:     (4560) Hidden Dual NonExtensible OleAutomation Dispatchable
// GUID:      {00000505-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  Field15Disp = interface
    ['{00000505-0000-0010-8000-00AA006D2EA4}']
    property ActualSize: Integer readonly dispid 1109;
    property Attributes: Integer readonly dispid 1036;
    property DefinedSize: Integer readonly dispid 1103;
    property Name: WideString readonly dispid 1100;
    property Type_: DataTypeEnum readonly dispid 1102;
    property Value: OleVariant dispid 0;
    property Precision: Byte readonly dispid 1610809351;
    property NumericScale: Byte readonly dispid 1610809352;
    procedure AppendChunk(Data: OleVariant); dispid 1107;
    function GetChunk(Length: Integer): OleVariant; dispid 1108;
    property OriginalValue: OleVariant readonly dispid 1104;
    property UnderlyingValue: OleVariant readonly dispid 1105;
    property Properties: Properties readonly dispid 500;
  end;
*)
// *********************************************************************//
// Interface: _Parameter
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000050C-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0000050C-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  _Parameter = interface { (_ADO) }
    // _ADO
    function get_Properties: Properties;
    property Properties: Properties read get_Properties;

    // _Parameter
    function get_Name: WideString;
    procedure set_Name(const pbstr: WideString); 
    function get_Value: TOleVarData;
    procedure set_Value(pvar: TOleVarData);
    function get_Type_: DataTypeEnum;
    procedure set_Type_(psDataType: DataTypeEnum); 
    procedure set_Direction(plParmDirection: ParameterDirectionEnum); 
    function get_Direction: ParameterDirectionEnum; 
    procedure set_Precision(pbPrecision: Byte); 
    function get_Precision: Byte; 
    procedure set_NumericScale(pbScale: Byte); 
    function get_NumericScale: Byte; 
    procedure set_Size(pl: Integer); 
    function get_Size: Integer; 
    procedure AppendChunk(Val: OleVariant); 
    function get_Attributes: Integer; 
    procedure set_Attributes(plParmAttribs: Integer);
    property Name: WideString read get_Name write set_Name;
    property Value: TOleVarData read get_Value write set_Value;
    property Type_: DataTypeEnum read get_Type_ write set_Type_;
    property Direction: ParameterDirectionEnum read get_Direction write set_Direction;
    property Precision: Byte read get_Precision write set_Precision;
    property NumericScale: Byte read get_NumericScale write set_NumericScale;
    property Size: Integer read get_Size write set_Size;
    property Attributes: Integer read get_Attributes write set_Attributes;
  end;

// *********************************************************************//
// DispIntf:  _ParameterDisp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000050C-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  _ParameterDisp = interface
    ['{0000050C-0000-0010-8000-00AA006D2EA4}']
    property Name: WideString dispid 1610809344;
    property Value: OleVariant dispid 0;
    property Type_: DataTypeEnum dispid 1610809348;
    property Direction: ParameterDirectionEnum dispid 1610809350;
    property Precision: Byte dispid 1610809352;
    property NumericScale: Byte dispid 1610809354;
    property Size: Integer dispid 1610809356;
    procedure AppendChunk(Val: OleVariant); dispid 1610809358;
    property Attributes: Integer dispid 1610809359;
    property Properties: Properties readonly dispid 500;
  end;
*)
// *********************************************************************//
// Interface: Parameters
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000050D-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0000050D-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  Parameters = interface { (_DynaCollection) }
    // _Collection
    function get_Count: Integer;
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function _NewEnum: TObject; // IUnknown
    procedure Refresh;
    property Count: Integer read get_Count;

    // _DynaCollection
    procedure Append([MarshalAs(UnmanagedType.IDispatch)] const Object_: TObject);
    procedure Delete(Index: OleVariant);

    // Parameters
    function get_Item(Index: OleVariant): _Parameter;
    property Item[Index: OleVariant]: _Parameter read get_Item;
  end;

// *********************************************************************//
// DispIntf:  ParametersDisp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000050D-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  ParametersDisp = interface
    ['{0000050D-0000-0010-8000-00AA006D2EA4}']
    property Item[Index: OleVariant]: _Parameter readonly dispid 0; default;
    procedure Append(const Object_: IDispatch); dispid 1610809344;
    procedure Delete(Index: OleVariant); dispid 1610809345;
    property Count: Integer readonly dispid 1610743808;
    function _NewEnum: IUnknown; dispid -4;
    procedure Refresh; dispid 1610743810;
  end;
*)
// *********************************************************************//
// Interface: _Command
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000054E-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('0000054E-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  _Command = interface { (Command15) }
    // _ADO
    function get_Properties: Properties;
    property Properties: Properties read get_Properties;

    // Command15
    function get_ActiveConnection: _Connection;
    procedure set_ActiveConnection(const ppvObject: _Connection);
    procedure _set_ActiveConnection(ppvObject: OleVariant);
    function get_CommandText: WideString;
    procedure set_CommandText(const pbstr: WideString);
    function get_CommandTimeout: Integer;
    procedure set_CommandTimeout(pl: Integer);
    function get_Prepared: WordBool;
    procedure set_Prepared(pfPrepared: WordBool);
    function Execute(out RecordsAffected: OleVariant; [in] var Parameters: OleVariant; Options: Integer): _Recordset;
    function CreateParameter(const Name: WideString; Type_: DataTypeEnum;
      Direction: ParameterDirectionEnum; Size: Integer; Value: OleVariant): _Parameter;
    function get_Parameters: Parameters;
    procedure set_CommandType(plCmdType: CommandTypeEnum);
    function get_CommandType: CommandTypeEnum;
    function get_Name: WideString;
    procedure set_Name(const pbstrName: WideString);
    property CommandText: WideString read get_CommandText write set_CommandText;
    property CommandTimeout: Integer read get_CommandTimeout write set_CommandTimeout;
    property Prepared: WordBool read get_Prepared write set_Prepared;
    property Parameters: Parameters read get_Parameters;
    property CommandType: CommandTypeEnum read get_CommandType write set_CommandType;
    property Name: WideString read get_Name write set_Name;

    // _Command
    function get_State: Integer;
    procedure Cancel;
    property State: Integer read get_State;
  end;

// *********************************************************************//
// DispIntf:  _CommandDisp
// Flags:     (4544) Dual NonExtensible OleAutomation Dispatchable
// GUID:      {0000054E-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  _CommandDisp = interface
    ['{0000054E-0000-0010-8000-00AA006D2EA4}']
    property State: Integer readonly dispid 1610874880;
    procedure Cancel; dispid 1610874881;
    function ActiveConnection: _Connection; dispid 1610809344;
    property CommandText: WideString dispid 1610809347;
    property CommandTimeout: Integer dispid 1610809349;
    property Prepared: WordBool dispid 1610809351;
    function Execute(out RecordsAffected: OleVariant; const Parameters: OleVariant; Options: Integer): _Recordset; dispid 1610809353;
    function CreateParameter(const Name: WideString; Type_: DataTypeEnum;
      Direction: ParameterDirectionEnum; Size: Integer; Value: OleVariant): _Parameter; dispid 1610809354;
    property Parameters: Parameters readonly dispid 0;
    property CommandType: CommandTypeEnum dispid 1610809356;
    property Name: WideString dispid 1610809358;
    property Properties: Properties readonly dispid 500;
  end;
*)
// *********************************************************************//
// Interface: ConnectionEventsVt
// Flags:     (16) Hidden
// GUID:      {00000402-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000402-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ConnectionEventsVt = interface { (IUnknown) }
    procedure InfoMessage(const pError: Error; var adStatus: EventStatusEnum;
      const pConnection: _Connection);
    procedure BeginTransComplete(TransactionLevel: Integer; const pError: Error;
      var adStatus: EventStatusEnum; const pConnection: _Connection);
    procedure CommitTransComplete(const pError: Error; var adStatus: EventStatusEnum;
      const pConnection: _Connection);
    procedure RollbackTransComplete(const pError: Error; var adStatus: EventStatusEnum;
      const pConnection: _Connection);
    procedure WillExecute(var Source: WideString; var CursorType: CursorTypeEnum;
      var LockType: LockTypeEnum; var Options: Integer;
      var adStatus: EventStatusEnum; const pCommand: _Command;
      const pRecordset: _Recordset; const pConnection: _Connection);
    procedure ExecuteComplete(RecordsAffected: Integer; const pError: Error;
      var adStatus: EventStatusEnum; const pCommand: _Command;
      const pRecordset: _Recordset; const pConnection: _Connection);
    procedure WillConnect(var ConnectionString: WideString; var UserID: WideString;
      var Password: WideString; var Options: Integer;
      var adStatus: EventStatusEnum; const pConnection: _Connection);
    procedure ConnectComplete(const pError: Error; var adStatus: EventStatusEnum;
      const pConnection: _Connection);
    procedure Disconnect(var adStatus: EventStatusEnum; const pConnection: _Connection);
  end;

// *********************************************************************//
// Interface: RecordsetEventsVt
// Flags:     (16) Hidden
// GUID:      {00000403-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000403-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  RecordsetEventsVt = interface { (IUnknown) }
    procedure WillChangeField(cFields: Integer; Fields: OleVariant;
      var adStatus: EventStatusEnum; const pRecordset: _Recordset);
    procedure FieldChangeComplete(cFields: Integer; Fields: OleVariant;
      const pError: Error; var adStatus: EventStatusEnum;
      const pRecordset: _Recordset); 
    procedure WillChangeRecord(adReason: EventReasonEnum;
      cRecords: Integer; var adStatus: EventStatusEnum;
      const pRecordset: _Recordset); 
    procedure RecordChangeComplete(adReason: EventReasonEnum;
      cRecords: Integer; const pError: Error;
      var adStatus: EventStatusEnum; const pRecordset: _Recordset); 
    procedure WillChangeRecordset(adReason: EventReasonEnum;
      var adStatus: EventStatusEnum; const pRecordset: _Recordset); 
    procedure RecordsetChangeComplete(adReason: EventReasonEnum;
      const pError: Error; var adStatus: EventStatusEnum;
      const pRecordset: _Recordset); 
    procedure WillMove(adReason: EventReasonEnum;
      var adStatus: EventStatusEnum; const pRecordset: _Recordset); 
    procedure MoveComplete(adReason: EventReasonEnum; const pError: Error;
      var adStatus: EventStatusEnum; const pRecordset: _Recordset); 
    procedure EndOfRecordset(var fMoreData: WordBool;
      var adStatus: EventStatusEnum; const pRecordset: _Recordset); 
    procedure FetchProgress(Progress, MaxProgress: Integer;
      var adStatus: EventStatusEnum; const pRecordset: _Recordset); 
    procedure FetchComplete(const pError: Error;
      var adStatus: EventStatusEnum; const pRecordset: _Recordset);
  end;

// *********************************************************************//
// DispIntf:  ConnectionEvents
// Flags:     (4096) Dispatchable
// GUID:      {00000400-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
(*  ConnectionEvents = interface
    ['{00000400-0000-0010-8000-00AA006D2EA4}']
    procedure InfoMessage(const pError: Error; var adStatus: EventStatusEnum;
      const pConnection: _Connection); dispid 0;
    procedure BeginTransComplete(TransactionLevel: Integer; const pError: Error;
      var adStatus: EventStatusEnum; const pConnection: _Connection); dispid 1;
    procedure CommitTransComplete(const pError: Error; var adStatus: EventStatusEnum;
      const pConnection: _Connection); dispid 3;
    procedure RollbackTransComplete(const pError: Error; var adStatus: EventStatusEnum;
      const pConnection: _Connection); dispid 2;
    procedure WillExecute(var Source: WideString; var CursorType: CursorTypeEnum;
      var LockType: LockTypeEnum; var Options: Integer;
      var adStatus: EventStatusEnum; const pCommand: _Command;
      const pRecordset: _Recordset; const pConnection: _Connection); dispid 4;
    procedure ExecuteComplete(RecordsAffected: Integer; const pError: Error;
      var adStatus: EventStatusEnum; const pCommand: _Command;
      const pRecordset: _Recordset; const pConnection: _Connection); dispid 5;
    procedure WillConnect(var ConnectionString: WideString; var UserID: WideString;
      var Password: WideString; var Options: Integer;
      var adStatus: EventStatusEnum; const pConnection: _Connection); dispid 6;
    procedure ConnectComplete(const pError: Error; var adStatus: EventStatusEnum;
      const pConnection: _Connection); dispid 7;
    procedure Disconnect(var adStatus: EventStatusEnum; const pConnection: _Connection); dispid 8;
  end;

// *********************************************************************//
// DispIntf:  RecordsetEvents
// Flags:     (4096) Dispatchable
// GUID:      {00000266-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  RecordsetEvents = interface
    ['{00000266-0000-0010-8000-00AA006D2EA4}']
    procedure WillChangeField(cFields: Integer; Fields: OleVariant; var adStatus: EventStatusEnum;
      const pRecordset: _Recordset); dispid 9;
    procedure FieldChangeComplete(cFields: Integer; Fields: OleVariant; const pError: Error;
      var adStatus: EventStatusEnum; const pRecordset: _Recordset); dispid 10;
    procedure WillChangeRecord(adReason: EventReasonEnum; cRecords: Integer;
      var adStatus: EventStatusEnum; const pRecordset: _Recordset); dispid 11;
    procedure RecordChangeComplete(adReason: EventReasonEnum; cRecords: Integer;
      const pError: Error; var adStatus: EventStatusEnum;
      const pRecordset: _Recordset); dispid 12;
    procedure WillChangeRecordset(adReason: EventReasonEnum; var adStatus: EventStatusEnum;
      const pRecordset: _Recordset); dispid 13;
    procedure RecordsetChangeComplete(adReason: EventReasonEnum; const pError: Error;
      var adStatus: EventStatusEnum; const pRecordset: _Recordset); dispid 14;
    procedure WillMove(adReason: EventReasonEnum; var adStatus: EventStatusEnum;
      const pRecordset: _Recordset); dispid 15;
    procedure MoveComplete(adReason: EventReasonEnum; const pError: Error;
      var adStatus: EventStatusEnum; const pRecordset: _Recordset); dispid 16;
    procedure EndOfRecordset(var fMoreData: WordBool; var adStatus: EventStatusEnum;
      const pRecordset: _Recordset); dispid 17;
    procedure FetchProgress(Progress: Integer; MaxProgress: Integer; var adStatus: EventStatusEnum;
      const pRecordset: _Recordset); dispid 18;
    procedure FetchComplete(const pError: Error; var adStatus: EventStatusEnum;
      const pRecordset: _Recordset); dispid 19;
  end;

// *********************************************************************//
// Interface: ADOConnectionConstruction15
// Flags:     (512) Restricted
// GUID:      {00000516-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  ADOConnectionConstruction15 = interface(IUnknown)
    ['{00000516-0000-0010-8000-00AA006D2EA4}']
    function get_DSO: IUnknown; safecall;
    function get_Session: IUnknown; safecall;
    procedure WrapDSOandSession(const pDSO: IUnknown; const pSession: IUnknown); safecall;
  end;

// *********************************************************************//
// Interface: ADOConnectionConstruction
// Flags:     (512) Restricted
// GUID:      {00000551-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  ADOConnectionConstruction = interface(ADOConnectionConstruction15)
    ['{00000551-0000-0010-8000-00AA006D2EA4}']
  end;
*)

// *********************************************************************//
// Interface: ADOCommandConstruction
// Flags:     (512) Restricted
// GUID:      {00000517-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000517-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ADOCommandConstruction = interface { (IUnknown) }
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function get_OLEDBCommand: TObject; // IUnknown
    procedure set_OLEDBCommand([in, MarshalAs(UnmanagedType.IUnknown)] ppOLEDBCommand: TObject);
    property OLEDBCommand: TObject read get_OLEDBCommand write set_OLEDBCommand;
  end;

// *********************************************************************//
// Interface: ADORecordsetConstruction
// Flags:     (4608) Restricted Dispatchable
// GUID:      {00000283-0000-0010-8000-00AA006D2EA4}
// *********************************************************************//
  [ComImport,
  GuidAttribute('00000283-0000-0010-8000-00AA006D2EA4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  ADORecordsetConstruction = interface { (IDispatch) }
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function get_Rowset: TObject; // IUnknown
    procedure set_Rowset([in, MarshalAs(UnmanagedType.IUnknown)] ppRowset: TObject);
    function get_Chapter: Integer;
    procedure set_Chapter(plChapter: Integer);
    [result: MarshalAs(UnmanagedType.IUnknown)]
    function get_RowPosition: TObject; // IUnknown
    procedure set_RowPosition([in, MarshalAs(UnmanagedType.IUnknown)] ppRowPos: TObject);
    property Rowset: TObject read get_Rowset write set_Rowset;
    property Chapter: Integer read get_Chapter write set_Chapter;
    property RowPosition: TObject read get_RowPosition write set_RowPosition;
  end;

// *********************************************************************//
// Interface: IDataspace
// Flags:     (4432) Hidden Dual OleAutomation Dispatchable
// GUID:      {BD96C556-65A3-11D0-983A-00C04FC29E34}
// *********************************************************************//
  [ComImport,
  GuidAttribute('BD96C556-65A3-11D0-983A-00C04FC29E34'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsDual)]
  IDataspace = interface { (IDispatch) }
    function  CreateObject(const bstrProgid: WideString;
      const bstrConnection: WideString): OleVariant;
    function  get_InternetTimeout: Integer;
    procedure set_InternetTimeout(plInetTimeout: Integer);
    property InternetTimeout: Integer read get_InternetTimeout write set_InternetTimeout;
  end;

// *********************************************************************//
// DispIntf:  IDataspaceDisp
// Flags:     (4432) Hidden Dual OleAutomation Dispatchable
// GUID:      {BD96C556-65A3-11D0-983A-00C04FC29E34}
// *********************************************************************//
(*  IDataspaceDisp = interface
    ['{BD96C556-65A3-11D0-983A-00C04FC29E34}']
    function  CreateObject(const bstrProgid: WideString;
      const bstrConnection: WideString): OleVariant; dispid 1;
    property InternetTimeout: Integer dispid 222;
  end;
*)
{ CoClass Creators }

  CoConnection = class
    class function _Create: _Connection;
    class function CreateRemote(const MachineName: string): _Connection;
  end;

  CoCommand = class
    class function _Create: _Command;
    class function CreateRemote(const MachineName: string): _Command;
  end;

  CoRecordset = class
    class function _Create: _Recordset;
    class function CreateRemote(const MachineName: string): _Recordset;
  end;

  CoParameter = class
    class function _Create: _Parameter;
    class function CreateRemote(const MachineName: string): _Parameter;
  end;

implementation

uses ComObj;

{ CoClass Creators }

class function CoConnection._Create: _Connection;
begin
  Result := CreateComObject(TGuid.Create(CLASS_Connection)) as _Connection;
end;

class function CoConnection.CreateRemote(const MachineName: string): _Connection;
begin
  Result := CreateRemoteComObject(MachineName, TGuid.Create(CLASS_Connection)) as _Connection;
end;

class function CoCommand._Create: _Command;
begin
  Result := CreateComObject(TGuid.Create(CLASS_Command)) as _Command;
end;

class function CoCommand.CreateRemote(const MachineName: string): _Command;
begin
  Result := CreateRemoteComObject(MachineName, TGuid.Create(CLASS_Command)) as _Command;
end;

class function CoRecordset._Create: _Recordset;
begin
  Result := CreateComObject(TGuid.Create(CLASS_Recordset)) as _Recordset;
end;

class function CoRecordset.CreateRemote(const MachineName: string): _Recordset;
begin
  Result := CreateRemoteComObject(MachineName, TGuid.Create(CLASS_Recordset)) as _Recordset;
end;

class function CoParameter._Create: _Parameter;
begin
  Result := CreateComObject(TGuid.Create(CLASS_Parameter)) as _Parameter;
end;

class function CoParameter.CreateRemote(const MachineName: string): _Parameter;
begin
  Result := CreateRemoteComObject(MachineName, TGuid.Create(CLASS_Parameter)) as _Parameter;
end;

end.
